/*
 * Decompiled with CFR 0.152.
 */
package au.edu.uts.aip.bof.web;

import au.edu.uts.aip.bof.domain.Post;
import au.edu.uts.aip.bof.domain.PostDao;
import au.edu.uts.aip.bof.domain.User;
import au.edu.uts.aip.bof.domain.UserDao;
import au.edu.uts.aip.bof.domain.orm.DataSourceException;
import au.edu.uts.aip.bof.domain.orm.Id;
import au.edu.uts.aip.bof.web.UserController;
import java.sql.Timestamp;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@RequestScoped
public class PostController {
    @EJB
    private PostDao postDao;
    @EJB
    private UserDao userDao;
    @Inject
    private UserController userController;
    private String message;
    private User user;
    private List<Post> posts;
    private List<Post> userPosts;

    @PostConstruct
    public void init() {
        this.user = this.userController.getUser();
    }

    public void loadUser(int id) throws DataSourceException {
        this.user = (User)this.userDao.find(id);
    }

    public User getUser() {
        return this.user;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<Post> getUserPosts() throws DataSourceException {
        if (this.userPosts == null) {
            this.userPosts = this.postDao.findUserMessages(this.user);
        }
        return this.userPosts;
    }

    public List<Post> getPosts() throws DataSourceException {
        if (this.posts == null) {
            this.posts = this.postDao.findFriendMessages(this.user);
            for (Post post : this.posts) {
                post.setCreator((User)this.userDao.find(post.getCreator().getId()));
            }
        }
        return this.posts;
    }

    public void post() throws DataSourceException {
        Post post = new Post(this.user, this.message, new Timestamp(System.currentTimeMillis()), 0);
        this.postDao.create((Id)post);
        if (this.posts != null) {
            this.posts.add(0, post);
        }
        if (this.userPosts != null) {
            this.userPosts.add(0, post);
        }
    }

    public String like(int postId, String back, String friend) throws DataSourceException {
        this.postDao.like(postId);
        this.posts = null;
        this.userPosts = null;
        String outcome = back + "?faces-redirect=true";
        if (friend != null && friend.length() > 0) {
            outcome = outcome + "&friend=" + friend;
        }
        return outcome;
    }
}

