/*
 * Decompiled with CFR 0.152.
 */
package au.edu.uts.aip.bof.domain.config;

import au.edu.uts.aip.bof.domain.Friend;
import au.edu.uts.aip.bof.domain.FriendDao;
import au.edu.uts.aip.bof.domain.Post;
import au.edu.uts.aip.bof.domain.PostDao;
import au.edu.uts.aip.bof.domain.User;
import au.edu.uts.aip.bof.domain.UserDao;
import au.edu.uts.aip.bof.domain.orm.DataSourceException;
import au.edu.uts.aip.bof.domain.orm.Id;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.sql.DataSource;

@Singleton
@Startup
public class SampleData {
    @Inject
    private DataSource ds;
    @EJB
    private UserDao userDao;
    @EJB
    private FriendDao friendDao;
    @EJB
    private PostDao postDao;

    @PostConstruct
    public void init() {
        Logger logger = Logger.getLogger("au.edu.uts.aip.bof.domain.config");
        String drop = "drop table bof_dual;drop table bof_post;drop table bof_friend;drop table bof_user;";
        String schemaDual = "create table bof_dual(\n    x integer\n);\n\ninsert into bof_dual values (1);";
        String autoGenPlaceholder = "<AUTOGEN>";
        String derbyAutoGen = "generated always as identity";
        String mySqlAutoGen = "auto_increment";
        String schema = "create table bof_user(\n    id integer primary key not null <AUTOGEN>,\n    username varchar(255),\n    password varchar(255),\n    fullName varchar(255)\n);\n\ncreate table bof_friend(\n    id integer primary key not null <AUTOGEN>,\n    friendFrom integer,\n    friendTo integer,\n    constraint friendFrom_fk foreign key (friendFrom) references bof_user(id),\n    constraint friendTo_fk foreign key (friendTo) references bof_user(id)\n);\n\ncreate table bof_post(\n    id integer primary key not null <AUTOGEN>,\n    creator integer,\n    message varchar(8196),\n    creationDate timestamp,\n    likes integer,\n    constraint creator_fk foreign key (creator) references bof_user(id)\n);";
        try (Connection conn = this.ds.getConnection();){
            Throwable throwable;
            Statement stmt;
            try {
                stmt = conn.createStatement();
                throwable = null;
                try {
                    this.execute(stmt, drop);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Tried to drop existing database tables but failed -- this is probably the first time you have run the application");
            }
            stmt = conn.createStatement();
            throwable = null;
            try {
                this.execute(stmt, schemaDual);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            try {
                stmt = conn.createStatement();
                throwable = null;
                try {
                    this.execute(stmt, schema.replaceAll(autoGenPlaceholder, derbyAutoGen));
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Failed to create database tables using Derby/JavaDB syntax, trying MySQL");
                try (Statement stmt2 = conn.createStatement();){
                    this.execute(stmt2, schema.replaceAll(autoGenPlaceholder, mySqlAutoGen));
                }
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Could not initialize database", e);
        }
        try {
            User carol = new User("carol", "password", "Carol");
            User mike = new User("mike", "qwerty", "Mike");
            User alice = new User("alice", "123456", "Alice");
            User sam = new User("sam", "iloveyou", "Sam");
            User greg = new User("greg", "bravo", "Greg");
            User peter = new User("peter", "volcano", "Peter");
            User bobby = new User("bobby", "racecar", "Bobby");
            User marcia = new User("marcia", "davyjones", "Marcia");
            User jan = new User("jan", "glass", "Jan");
            User cindy = new User("cindy", "thindy", "Cindy");
            this.userDao.create((Id)carol);
            this.userDao.create((Id)mike);
            this.userDao.create((Id)alice);
            this.userDao.create((Id)sam);
            this.userDao.create((Id)greg);
            this.userDao.create((Id)peter);
            this.userDao.create((Id)bobby);
            this.userDao.create((Id)marcia);
            this.userDao.create((Id)jan);
            this.userDao.create((Id)cindy);
            this.friendDao.create((Id)new Friend(marcia, carol));
            this.friendDao.create((Id)new Friend(marcia, jan));
            this.friendDao.create((Id)new Friend(jan, marcia));
            this.friendDao.create((Id)new Friend(jan, alice));
            this.friendDao.create((Id)new Friend(jan, cindy));
            this.friendDao.create((Id)new Friend(cindy, jan));
            this.friendDao.create((Id)new Friend(cindy, mike));
            this.friendDao.create((Id)new Friend(carol, marcia));
            this.friendDao.create((Id)new Friend(carol, greg));
            this.friendDao.create((Id)new Friend(carol, alice));
            this.friendDao.create((Id)new Friend(alice, carol));
            this.friendDao.create((Id)new Friend(alice, jan));
            this.friendDao.create((Id)new Friend(alice, peter));
            this.friendDao.create((Id)new Friend(alice, mike));
            this.friendDao.create((Id)new Friend(mike, alice));
            this.friendDao.create((Id)new Friend(mike, cindy));
            this.friendDao.create((Id)new Friend(mike, bobby));
            this.friendDao.create((Id)new Friend(greg, carol));
            this.friendDao.create((Id)new Friend(greg, peter));
            this.friendDao.create((Id)new Friend(peter, greg));
            this.friendDao.create((Id)new Friend(peter, alice));
            this.friendDao.create((Id)new Friend(peter, bobby));
            this.friendDao.create((Id)new Friend(bobby, peter));
            this.friendDao.create((Id)new Friend(bobby, mike));
            this.friendDao.create((Id)new Friend(alice, sam));
            this.friendDao.create((Id)new Friend(sam, alice));
            this.postDao.create((Id)new Post(mike, "It has been a busy week", Timestamp.valueOf("2014-10-2 09:00:00"), 5));
            this.postDao.create((Id)new Post(mike, "Finished designs for new building.", Timestamp.valueOf("2014-10-4 16:15:00"), 2));
            this.postDao.create((Id)new Post(mike, "Received Father of the Year award. Wow!", Timestamp.valueOf("2014-10-5 12:33:00"), 5));
            this.postDao.create((Id)new Post(carol, "Enjoying a nightcap with hubby", Timestamp.valueOf("2014-10-5 18:42:00"), 5));
            this.postDao.create((Id)new Post(carol, "Teaching the boys to dance", Timestamp.valueOf("2014-10-8 4:55:00"), 4));
            this.postDao.create((Id)new Post(alice, "Cleaning, cleaning. Always cleaning.", Timestamp.valueOf("2014-10-1 13:21:00"), 3));
            this.postDao.create((Id)new Post(alice, "Cooking up a storm in the kitchen", Timestamp.valueOf("2014-10-2 11:49:00"), 2));
            this.postDao.create((Id)new Post(sam, "At the meat market", Timestamp.valueOf("2014-10-5 08:01:00"), 2));
            this.postDao.create((Id)new Post(sam, "Thinking of buying a new refrigerator", Timestamp.valueOf("2014-10-6 12:05:00"), 1));
            this.postDao.create((Id)new Post(greg, "Bobby is so immature", Timestamp.valueOf("2014-10-2 16:59:00"), 3));
            this.postDao.create((Id)new Post(greg, "Another school day. :(", Timestamp.valueOf("2014-10-4 07:32:00"), 5));
            this.postDao.create((Id)new Post(greg, "Listening to the new Jonny Bravo single", Timestamp.valueOf("2014-10-7 17:38:00"), 8));
            this.postDao.create((Id)new Post(peter, "Saved a life today", Timestamp.valueOf("2014-10-3 18:05:00"), 1));
            this.postDao.create((Id)new Post(peter, "Am I dull?", Timestamp.valueOf("2014-10-3 18:22:00"), 0));
            this.postDao.create((Id)new Post(bobby, "Clairol #43. Ugh!", Timestamp.valueOf("2014-10-5 10:10:00"), 4));
            this.postDao.create((Id)new Post(bobby, "Feeling afraid of heights", Timestamp.valueOf("2014-10-7 13:52:00"), 0));
            this.postDao.create((Id)new Post(marcia, "I could listen to Davy Jones all night", Timestamp.valueOf("2014-10-7 20:19:00"), 0));
            this.postDao.create((Id)new Post(jan, "Feeling low", Timestamp.valueOf("2014-10-8 09:15:00"), 0));
            this.postDao.create((Id)new Post(cindy, "I have just heard an amazing secret", Timestamp.valueOf("2014-10-5 13:11:00"), 0));
        }
        catch (DataSourceException e) {
            logger.log(Level.SEVERE, "Could not populate database with sample data", e);
        }
    }

    private void execute(Statement stmt, String query) throws SQLException {
        for (String command : query.split(";")) {
            stmt.addBatch(command);
        }
        stmt.executeBatch();
    }
}

